	subroutine ASSEMBLE(iout, idbg, Ne, Nn, Nd, NnNd, &
			vA, vB, &
			rA, rB, &
			cA, cB, &
			lastA, lastB, &
			Ae, Be, ie, e)
! assemble arrays

	implicit none
	integer iout, idbg
	integer Ne, Nn, Nd, NnNd		! array parameters
	integer lastA, lastB
	real*8 Ae(4,4), Be(4,4)			! element arrays
	integer ie(Ne,5)			! global connectivity array
	integer rA (Nn+1), rB(Nn+1)		! global  arrays (compact rows)
	integer cA (NnNd), cB(NnNd)		! global  arrays (compact columns)
	real*8 vA (NnNd), vB(NnNd)		! global  arrays (compact values)
	integer e

	integer i, j

!	write(idbg,'(a)') ' --- ASSEMBLE ---'	! ### TEMPORARY ###

! assemble rank 2 sparse arrays
	do i = 1,4
	  do j = 1,4
	    call ASSEMBLE2(iout, idbg, Nn, NnNd, lastA, vA, cA, rA, &
			ie(e,i), ie(e,j), Ae(i,j), 1)
	    call ASSEMBLE2(iout, idbg, Nn, NnNd, lastB, vB, cB, rB, &
			ie(e,i), ie(e,j), Be(i,j), 1)
	  enddo		! j
	enddo		! i
				
	return
	end
